package com.android.browser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import android.util.Log;

/**
 * I write a plain text file instead of using shared preference for 3 reasons:
 * 		1) Keeps native android preference separate from crestron related settings
 * 		2) Don't need to handle XML parsing, this is simpler and quicker.
 * 		3) Mobile Value is stored as a weakhashmap probably in db, but not in flat file which i can't find atm in code
 * @author Walter
 *
 */
public class FileHandler  {

    private static final String TAG = "FileReader";
	private File uaPreferenceFile;
	private String userAgentFilePath = "/data/data/com.android.browser/crestron_user_agent.txt";
	private String crestronHomepageFilePath = "/data/data/com.android.browser/crestron_homepage.txt";
	private static final String DEF_CRESTRON_HOMEPAGE = "file:///homepage/index.html";
	/**
	 * onResume() read preference to check to see if setting was changed while closed
	 * @return
	 */
	public boolean readUAPref(){
		
			BufferedReader br = null;
			boolean isDesktopBrowser = false;
			String input = null;
					
			uaPreferenceFile = new File(userAgentFilePath);
			if (!uaPreferenceFile.exists()) {
				try {
					uaPreferenceFile.createNewFile();
				} catch (IOException e) {
					Log.e(TAG, "Could not create preference file, returning false.", e);
					return false;
				}
			}
			
			try {
					br = new BufferedReader(new FileReader(uaPreferenceFile));
					if(br != null){
						input = br.readLine();
					}
						
					br.close();

			} catch (Exception e) {
				Log.e(TAG, "Could not read files", e);
				br = null;
			}
	
			if(input != null && input.trim().equals("true")){
				isDesktopBrowser = true;
			}

//			 Log.i(TAG,"User agent file returned:" + isDesktopBrowser);
			 return isDesktopBrowser;
	}

	/**
	 * onResume() read preference to check to see if setting was changed while closed
	 * @return
	 */
	public String readHomepagePref(){
		
			BufferedReader br = null;
			boolean isDesktopBrowser = false;
			String input = null;
			
			File crestronHomepagePreferenceFile = new File(crestronHomepageFilePath);
			if (!crestronHomepagePreferenceFile.exists()) {
				return  DEF_CRESTRON_HOMEPAGE;//if doesn't exist return default
			}

			try {
					br = new BufferedReader(new FileReader(crestronHomepageFilePath));
					
					if(br != null){
						input = br.readLine();
						br.close();
					}

			} catch (Exception e) {
				Log.e(TAG, "Could not read files", e);
				br = null;
			}
	
			if(input != null){

				if(!input.startsWith("http://") && !input.startsWith("file://") && !input.startsWith("/homepage") && input.startsWith("www.")){
					Log.i("TEST", "appending http:// to homepage");
					input = "http://" + input;
				}

						
				return UrlUtils.fixUrl(input);
			}

			return  DEF_CRESTRON_HOMEPAGE;//if doesn't exist return default
	}
	
	
	public void writePref(boolean isDesktopUserAgent) {
		BufferedWriter br = null;
		uaPreferenceFile = new File(userAgentFilePath);
		if (!uaPreferenceFile.exists()) {
			try {
				uaPreferenceFile.createNewFile();
			} catch (IOException e) {
				Log.e(TAG, "Could not write preference file.", e);
				return;
			}
		}
		try {
				br = new BufferedWriter(new FileWriter(uaPreferenceFile));
				if (isDesktopUserAgent)
					br.write("true\n");
				else
					br.write("false\n");
				
				br.flush();
				br.close();
			
		} catch (Exception e) {
			Log.e(TAG, "Could not read files", e);
			br = null;
		}

	}

}

